% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectCharacterType.R
\name{forceNames}
\alias{forceNames}
\title{Force names for rows, columns, or both}
\usage{
forceNames(dat, nameType = "row")
}
\arguments{
\item{dat}{A vector of data}

\item{nameType, }{either:
\describe{
\item{"row"}{Rows (default)}
\item{"col"}{Columns}
\item{"rowcol"}{Both rows and columns}
}}
}
\value{
An object of type `data.frame with labeled columns, rows, or both.
}
\description{
This function creates column names (\code{colnames}), row.names (\code{row.names}),
or both in an unnamed \code{data.frame} or \code{matrix}.
}
\examples{
data(anolis)
forceNames(anolis$dat, "row")
}
