% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_cophylo_summary_stat.R
\name{parafit_stat}
\alias{parafit_stat}
\alias{parafit_test}
\title{Calculate the ParafitGlobal statistic on 2 trees and their association matrix}
\usage{
parafit_stat(host_tr, symb_tr, assoc_mat)

parafit_test(host_tr, symb_tr, assoc_mat, D, reps = 99)
}
\arguments{
\item{host_tr}{The host tree of class "phy"}

\item{symb_tr}{The symbiont tree of class "phy}

\item{assoc_mat}{Association matrix between the extant tips of `host_tr` and `symb_tr`}

\item{D}{the statistic calculated using `parafit_stat`}

\item{reps}{Number of permutations to perform on the association matrix for the hypothesis test}
}
\value{
A p-value for the hypothesis test described above
}
\description{
Calculate the ParafitGlobal Statistic to be used in the hypothesis test described in Legendre et al. (2002).
The null hypothesis of this test being that the evolution of the two trees together with their associations at the present
have been independent.
}
\details{
`parafit_stat` drops any non-extant tips from the tree. Then the phylogenetic distance matrix is obtained for both host and symbiont tree.
Next the principal coordinates are found for the host and symbiont distance matrices before these PCoA vectors are used in the following
matrix multiplication following Legendre et al. (2002): D = H t(A) A. The trace is then found of this to get our ParaFitGlobal Statistic.

The test function `parafit_test` performs a row-wise permutation of the association matrix as described in Legendre et al. 2002. This is
performed a number of times set by the user (default is 999) and a p-value is output.

The value from this is input into the test function. Note that this gives only the raw statistic unlike `ape::parafit`. That is the
only reason it is implemented here in treeducken (similar to `treeducken::cherries`).
}
\section{Functions}{
\itemize{
\item \code{parafit_test}: Perform ParaFit Hypothesis Test
}}

\examples{
tr_pair <- sim_cophylo_bdp(hbr=0.1,
                          hdr=0.05,
                          sdr=0.1,
                          host_exp_rate=0.4,
                          sbr = 0.05,
                          cosp_rate = 1.0,
                          numbsim = 1,
                          time_to_sim = 1)
# maybe we are interested in only cophylogenetic object 1
ht <- tr_pair[[1]]$host_tree
st <- tr_pair[[1]]$symb_tree
A <- tr_pair[[1]]$association_mat
pfs <- parafit_stat(host_tr = ht, symb_tr = st, assoc_mat = A)

parafit_test(ht, st, A, pfs, reps = 19)
}
\references{
Legendre, P., Y. Desdevises and E. Bazin. 2002. A statistical test for host-parasite coevolution. Systematic Biology, 51(2), 217–234.
}
\seealso{
parafit_test
}
