% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_tree.R
\name{heat_tree}
\alias{heat_tree}
\title{Draws and aligns decision tree and heatmap.}
\usage{
heat_tree(
  data,
  data_test = NULL,
  target_lab,
  task = c("classification", "regression"),
  feat_types = NULL,
  label_map = NULL,
  target_cols = NULL,
  target_lab_disp = target_lab,
  clust_samps = TRUE,
  clust_target = TRUE,
  custom_tree = NULL,
  custom_layout = NULL,
  heat_rel_height = 0.2,
  lev_fac = 1.3,
  panel_space = 0.001,
  ...
)
}
\arguments{
\item{data}{Tidy dataset.}

\item{data_test}{Tidy test dataset. If NULL, heatmap displays (training) `data`.}

\item{target_lab}{Name of the column in data that contains target/label information.}

\item{task}{Character string indicating the type of problem,
either 'classification' (categorical outcome) or 'regression' (continuous outcome).}

\item{feat_types}{Named vector indicating the type of each features,
e.g., c(sex = 'factor', age = 'numeric').
If feature types are not supplied, infer from column type.}

\item{label_map}{Named vector of the meaning of the target values,
e.g., c(`0` = 'Edible', `1` = 'Poisonous').}

\item{target_cols}{Character vectors representing the hex values of different
level colors for targets, defaults to viridis option B.}

\item{target_lab_disp}{Character string for displaying the label of target label.
If NULL, use `target_lab`.}

\item{clust_samps}{Logical. If TRUE, hierarhical clustering would be performed
among samples within each leaf node.}

\item{clust_target}{Logical. If TRUE, target/label is included in hierarchical clustering
of samples within each leaf node and might yield a more interpretable heatmap.}

\item{custom_tree}{Custom tree with the partykit syntax.
https://cran.r-project.org/web/packages/partykit/vignettes/partykit.pdf
If NULL, a conditional inference tree is computed.}

\item{custom_layout}{Dataframe with 3 columns: id, x and y
for manually input custom layout.}

\item{heat_rel_height}{Relative height of heatmap compared to whole figure (with tree).}

\item{lev_fac}{Relative weight of child node positions
according to their levels, commonly ranges from 1 to 1.5.
1 for parent node perfectly in the middle of child nodes.}

\item{panel_space}{Spacing between facets relative to viewport,
recommended to range from 0.001 to 0.01.}

\item{\dots}{Further arguments passed to `draw_tree()` and/or `draw_heat()`.}
}
\value{
A gtable/grob object of the decision tree (top) and heatmap (bottom).
}
\description{
Draws and aligns decision tree and heatmap.
}
\examples{
heat_tree(penguins, target_lab = 'species')

heat_tree(
  data = galaxy[1:100, ],
  target_lab = 'target',
  task = 'regression',
  terminal_vars = NULL,
  tree_space_bottom = 0)

}
