% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcDstRF}
\alias{calcDstRF}
\title{Calculate the Robinson-Foulds distance between two trees}
\usage{
calcDstRF(tree_1, tree_2, nrmlsd = FALSE, parallel = FALSE,
  progress = "none")
}
\arguments{
\item{tree_1}{\code{TreeMan} object}

\item{tree_2}{\code{TreeMan} object}

\item{nrmlsd}{Boolean, should returned value be between 0 and 1? Default, FALSE.}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the Robinson-Foulds distance between two trees.
}
\details{
RF distance is calculated as the sum of partitions in one tree that are
not shared by the other. The maximum number of split differences is the total number
of nodes in both trees (excluding the roots). Trees are assumed to be bifurcating,
this is not tested. The metric is calculated as if trees are unrooted. Parallelizable.
}
\examples{
library(treeman)
tree_1 <- randTree(10)
tree_2 <- randTree(10)
calcDstRF(tree_1, tree_2)
}
\references{
Robinson, D. R.; Foulds, L. R. (1981). "Comparison of phylogenetic trees".
Mathematical Biosciences 53: 131-147.
}
\seealso{
\code{\link{calcDstBLD}}, \code{\link{calcDstTrp}} 
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}
