% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsPD}
\alias{getNdsPD}
\title{Get phylogenetic diversities of nodes}
\usage{
getNdsPD(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return summed value of all descending spns
}
\details{
Sums the lengths of all descending branches from a node.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsPD(tree, ids=tree['all'])  # return PD of all ids
}
\seealso{
\code{\link{getNdPD}},
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
