\name{treepalette}
\alias{treepalette}
\title{Hierarchical color palettes}
\usage{
  treepalette(dtf, index = names(dtf), method = "HCL",
    palette = NULL, palette.HCL.options,
    return.parameters = TRUE, prepare.dat = TRUE)
}
\arguments{
  \item{dtf}{a data.frame or data.table. Required.}

  \item{index}{the index variables of dtf}

  \item{method}{used method: either \code{"HCL"}
  (recommended), which is based on the HCL color space
  model, or \code{"HSV"}, which uses the argument
  \code{palette}.}

  \item{palette}{color palette, which is only used for the
  HSV method}

  \item{palette.HCL.options}{list of advanced options to
  pick colors from the HCL space (when
  \code{method="HCL"}). This list contains: \describe{
  \item{\code{hue_start}:}{number between 0 and 360 that
  determines the starting hue value (default: 30)}
  \item{\code{hue_end}:}{number between \code{hue_start}
  and \code{hue_start + 360} that determines the ending hue
  value (default: 390)} \item{\code{hue_spread}:}{boolean
  that determines whether the colors are spread such that
  adjacent levels get more distinguishable colors. If
  \code{FALSE}, then the colors are equally distributed
  from \code{hue_start} to \code{hue_end} (default: TRUE)}
  \item{\code{hue_fraction}:}{number between 0 and 1 that
  determines the fraction of the hue circle that is used
  for recursive color picking: if 1 then the full hue
  circle is used, which means that the hue of the colors of
  lower-level nodes are spread maximally. If 0, then the
  hue of the colors of lower-level nodes are identical of
  the hue of their parents. (default: .5)}
  \item{\code{chroma}:}{chroma value of colors of the
  first-level nodes, that are determined by the first index
  variable (default: 60)}
  \item{\code{luminance}:}{luminance value of colors of the
  first-level nodes, i.e. determined by the first index
  variable (default: 70)} \item{\code{chroma_slope}:}{slope
  value for chroma of the non-first-level nodes. The chroma
  values for the second-level nodes are
  \code{chroma+chroma_slope}, for the third-level nodes
  \code{chroma+2*chroma_slope}, etc. (default: 5)}
  \item{\code{luminance_slope}:}{slope value for luminance
  of the non-first-level nodes (default: -10)}} For "depth"
  and "categorical" types, only the first two items are
  used.}

  \item{return.parameters}{should a data.frame with color
  values and parameter options be returned (\code{TRUE}),
  or just the vector of color values (\code{FALSE})?}

  \item{prepare.dat}{data is by default preprocessed,
  except for interal use}
}
\value{
  Either a vector of colors, or a data.frame is return (see
  \code{return.parameters}).
}
\description{
  Create hierarchical color palettes, either by using the
  HCL color space model, or by using an existing color
  palette with the HSV space. The former, which is
  recommended, is used in \code{\link{treemap}} (type
  \code{"index"}) and \code{\link{treegraph}}.
}

