% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.R
\name{proximity}
\alias{proximity}
\alias{proximity.default}
\alias{proximity.matrix}
\alias{proximity.ranger}
\title{Proximity matrix}
\usage{
proximity(x, ...)

\method{proximity}{default}(x, sparse = NULL, upper = TRUE, ...)

\method{proximity}{matrix}(x, sparse = NULL, upper = TRUE, ...)

\method{proximity}{ranger}(x, data = NULL, sparse = NULL, upper = TRUE, ...)
}
\arguments{
\item{x}{Either a \code{\link[ranger]{ranger}} object or a matrix of terminal 
node assignments (one row for each observation and one column for each tree 
in the forest).}

\item{...}{Additional optional argument. (Currently ignored.)}

\item{sparse}{Logical or \code{NULL} indicating whether or not the resulting 
matrix should be sparse. If \code{NULL} (the default) it is made sparse when 
more than half the entries are 0.}

\item{upper}{Logical indicating whether or not to return the proximities in
upper triangular form (\code{TRUE}) or as a symmetric matrix (\code{FALSE}).
Default is \code{TRUE}.}

\item{data}{Optional data frame passed on to 
\code{\link[ranger]{predict.ranger}}. It's a good idea to pass the data via 
this argument whenever \code{x} is a \code{\link[ranger]{ranger}} object. If
\code{NULL} (the default) it will be looked for recursively.}
}
\value{
A matrix or sparse Matrix (\code{sparse = TRUE}) of pairwise 
proximity (i.e., similarity) scores between training observations.
}
\description{
Compute proximity matrix from a random forest or matrix of terminal node
assignments (one row for each observation and one column for each tree in the 
forest).
}
