% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeplyr_functions.R
\name{tdapply}
\alias{tdapply}
\title{Apply a function over all treedata object columns and return a list of results, analogously to the 
normal apply function}
\usage{
tdapply(tdObject, MARGIN, FUN, ...)
}
\arguments{
\item{tdObject}{A treedata object}

\item{MARGIN}{the margin over which the data is applied (e.g. 1 = rows, 2 = columns)}

\item{FUN}{A function to apply over the data frame}

\item{...}{Additional parameters passed on to FUN}
}
\description{
Apply a function over all treedata object columns and return a list of results, analogously to the 
normal apply function
}
\details{
Note that if the parameter \code{phy} is specified in the additional parameters (i.e. '...'), 
then it will be substituted with the \code{treedata} object \code{$phy}.
}
\examples{
data(anolis)
td <- make.treedata(anolis$phy, anolis$dat)
td \%>\% forceNumeric(.) \%>\% tdapply(., 2, phytools::phylosig, tree=phy)
}
