% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_dependence.R
\name{plot_feature_dependence}
\alias{plot_feature_dependence}
\title{SHAP value based Feature Dependence plot}
\usage{
plot_feature_dependence(
  treeshap,
  variable,
  title = "Feature Dependence",
  subtitle = NULL
)
}
\arguments{
\item{treeshap}{A treeshap object produced with the \code{\link{treeshap}} function. \code{\link{treeshap.object}}.}

\item{variable}{name or index of variable for which feature dependence will be plotted.}

\item{title}{the plot's title, by default \code{'Feature Dependence'}.}

\item{subtitle}{the plot's subtitle. By default no subtitle.}
}
\value{
a \code{ggplot2} object
}
\description{
Depending on the value of a variable: how does it contribute into the prediction?
}
\examples{
\donttest{
library(xgboost)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
target <- fifa20$target
param <- list(objective = "reg:squarederror", max_depth = 3)
xgb_model <- xgboost::xgboost(as.matrix(data), params = param, label = target,
                              nrounds = 20, verbose = FALSE)
unified_model <- xgboost.unify(xgb_model, as.matrix(data))
x <- head(data, 100)
shaps <- treeshap(unified_model, x)
plot_feature_dependence(shaps, variable = "overall")
}
}
\seealso{
\code{\link{treeshap}} for calculation of SHAP values

\code{\link{plot_contribution}}, \code{\link{plot_feature_importance}}, \code{\link{plot_interaction}}
}
