% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language_symbol_name}
\alias{language_symbol_name}
\title{Language symbol names}
\usage{
language_symbol_name(x, symbol)
}
\arguments{
\item{x}{\verb{[tree_sitter_language]}

A tree-sitter language object.}

\item{symbol}{\verb{[positive integer]}

The language symbols to look up names for.}
}
\value{
A character vector the same length as \code{symbol} containing:
\itemize{
\item The name of the symbol, if known.
\item \code{NA}, if the symbol was not known.
}
}
\description{
Get the name for a particular language symbol ID. Can be useful for
exploring a grammar.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
language_symbol_name(language, 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=language_symbol_for_name]{language_symbol_for_name()}}
}
