% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliscope-data.R
\docType{data}
\name{batting}
\alias{batting}
\title{Lahman's Batting Data for 2014}
\format{A data frame with 1435 rows and 22 variables}
\source{
Lahman, S. (2015) Lahman's Baseball Database, 1871-2014, 2015 version, \url{http://baseball1.com/statistics/}.
}
\usage{
data(batting)
}
\description{
2014 Batting statistics from Sean Lahman's baseball statistics database (released under CC BY-SA 3.0 license).
}
\details{
\itemize{
  \item playerID  Player ID code
  \item yearID    Year
  \item stint     player's stint (order of appearances within a season)
  \item teamID    Team; a factor
  \item lgID      League; a factor with levels AA AL FL NL PL UA
  \item G         Games: number of games in which a player played
  \item AB        At Bats
  \item R         Runs
  \item H         Hits: times reached base because of a batted, fair ball without error by the defense
  \item X2B       Doubles: hits on which the batter reached second base safely
  \item X3B       Triples: hits on which the batter reached third base safely
  \item HR        Homeruns
  \item RBI       Runs Batted In
  \item SB        Stolen Bases
  \item CS        Caught Stealing
  \item BB        Base on Balls
  \item SO        Strikeouts
  \item IBB       Intentional walks
  \item HBP       Hit by pitch
  \item SH        Sacrifice hits
  \item SF        Sacrifice flies
  \item GIDP      Grounded into double plays
}
}
\examples{
\dontrun{
library(lattice)

vdbConn(tempfile(), autoYes = TRUE)

# make "splod" directly from a data frame
splod(batting, name = "batting",
  id.vars = c("playerID", "yearID", "stint", "teamID", "lgID"))

# first transform the data into a "splodDat" object
batSplodDat <- makeSplodData(batting,
  id.vars = c("playerID", "yearID", "stint", "teamID", "lgID"))
# now make "splod"
splod(batSplodDat, name = "batting2", data = batSplodDat)

# custom panel function (color by league)
mySplodFn <- function(d) {
  xyplot(jitter(y) ~ jitter(x), groups = lgID, data = d,
    xlab = getSplitVar(d, "xVar"),
    ylab = getSplitVar(d, "yVar"),
    auto.key = TRUE
  )
}

splod(batSplodDat, name = "batting3",
  data = batSplodDat, panelFn = mySplodFn)

view()
}
}
\keyword{datasets}
