% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognostics.R
\name{cogHref}
\alias{cogHref}
\title{Href Cognostic}
\usage{
cogHref(x, label = "link", desc = "link", group = "common",
  target = "_blank", defLabel = FALSE, defActive = FALSE,
  filterable = FALSE, sortable = TRUE, log = FALSE)
}
\arguments{
\item{x}{URL to link to}

\item{label}{label of the href}

\item{desc, group, defLabel, defActive, filterable, sortable, log}{arguments passed to \code{\link{cog}}}

\item{target}{value to be used for the \code{target} attribute of the \code{a} html tag - default is "_blank" which will open the link in a new window}
}
\description{
Create href to be used as cognostics in a trelliscope display.
}
\examples{
d <- divide(iris, by = "Species")

# cognostics function that links to wikipedia
cogFn <- function(x) {
  link <- paste0("https://en.wikipedia.org/wiki/Iris_", getSplitVar(x, "Species"))
  list(wiki = cogHref(link, desc = "Look up species on wikipedia", defLabel = TRUE))
}

# test the cognostics function on a subset
applyCogFn(cogFn, d[[1]])

# make a display with this cognostics function
vdbConn(tempfile(), autoYes = TRUE)
makeDisplay(d, name = "iris_sl_sw",
  cogFn = cogFn, panelFn = function(x)
    lattice::xyplot(Sepal.Length ~ Sepal.Width, data = x))

\dontrun{
# clicking the link under each panel will open wikipedia
view(name = "iris_sl_sw")
}
}
\seealso{
\code{\link{cog}}
}
