% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{makeStateHash}
\alias{makeStateHash}
\title{Make a URL hash out of state information}
\usage{
makeStateHash(x)
}
\arguments{
\item{x}{a list of cognostics state parameters}
}
\value{
a URL hash
}
\description{
Make a URL hash out of cognostics state information
}
\examples{
state <- stateSpec(
  name = "my_display",
  sort = list(state = "desc", county = "asc"),
  filter = list(
    county = list(regex = "Ben"),
    state = list(select = c("OR", "WA")),
    meanList = list(from = 50, to = 150)
  ),
  layout = list(nrow = 2, ncol = 4),
  labels = c("county", "state")
)

state <- validateState(state, checkDisplay = FALSE)

makeStateHash(state)
}
\seealso{
\code{\link{validateState}}
}
