% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_resource.R
\name{search_resource}
\alias{search_resource}
\alias{search_cards}
\alias{search_actions}
\alias{search_boards}
\alias{search_members}
\alias{search_teams}
\title{Search Trello}
\usage{
search_resource(
  string,
  resource = "all",
  boards = "mine",
  partial = FALSE,
  query = list(),
  modeltype,
  ...
)

search_cards(string, boards = "mine", partial = FALSE, query = list(), ...)

search_actions(string, boards = "mine", partial = FALSE, query = list(), ...)

search_boards(string, boards = "mine", partial = FALSE, query = list(), ...)

search_members(string, boards = "mine", partial = FALSE, query = list(), ...)

search_teams(string, boards = "mine", partial = FALSE, query = list(), ...)
}
\arguments{
\item{string}{Text to search for.}

\item{resource}{Type of resource to return; typically \code{"cards"}. Defaults to
\code{"all"}.}

\item{boards}{Boards to limit the search to - defaults to \code{"mine"}.}

\item{partial}{Should partial matching be used? Defaults to \code{FALSE}.}

\item{query}{Name list of additional query parameters; consult \href{https://developer.atlassian.com/cloud/trello/rest/#api-search-get}{search API reference}}

\item{modeltype}{Deprecated, use \code{resource} instead.}

\item{...}{Additional arguments passed to \code{\link[=get_resource]{get_resource()}}.}
}
\value{
A data frame.
}
\description{
Search for resources.
}
\details{
Search can be narrowed down by resource type and will return a single data
frame per each type (if anything is found). The value of the \code{resource}
argument is passed on \code{modelTypes} - see other attributes
at \href{https://developer.atlassian.com/cloud/trello/rest/#api-search-get}{search API reference}.
}
\examples{

\dontrun{

search_resource("Anything with this text")
search_cards("A card with this text")

}
}
\seealso{
\code{\link[=get_resource]{get_resource()}}, \code{\link[=get_token]{get_token()}}
}
