% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snht.test.R
\name{snh.test}
\alias{snh.test}
\title{Standard Normal Homogeinity Test (SNHT) for Change-Point Detection}
\usage{
snh.test(x, m = 20000)
}
\arguments{
\item{x}{a vector of class "numeric" or a time series object of class "ts"}

\item{m}{numeric, number of Monte-Carlo replicates, defaults to 20000}
}
\value{
A list with class "htest" and "cptest"
\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value}
\item{statistic}{the test statistic}
\item{null.value}{the null hypothesis}
\item{estimates}{the time of the probable change point}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
\item{data}{numeric vector of Tk for plotting}
}
\description{
Performes the Standard Normal Homogeinity Test (SNHT)
for change-point detection of a normal variate.
}
\details{
Let \eqn{X} denote a normal random variate, then the following model
with a single shift (change-point) can be proposed:

\deqn{
  x_i = \left\{
      \begin{array}{lcl}
       \mu + \epsilon_i, & \qquad & i = 1, \ldots, m \\
       \mu + \Delta + \epsilon_i & \qquad & i = m + 1, \ldots, n \\
      \end{array} \right.}{%
  x[i] = \mu + \epsilon[i] for i = 1, ..., m and x[i] = \mu + \delta
  + \epsilon_i for i = m + 1, ..., n}

with \eqn{\epsilon \approx N(0,\sigma)}. The null hypothesis \eqn{\Delta = 0}
is tested against the alternative \eqn{\Delta \ne 0}{\delta != 0}.

The test statistic for the SNHT test is calculated as follows:

\deqn{T_k = k z_1^2 + \left(n - k\right) z_2^2 \qquad (1 \le k < n)}{%
T[k] = k z[1]^2 + (n - k) z[2]^2    (1 <= k < n)}

where

\deqn{
\begin{array}{l l}
z_1 = \frac{1}{k} \sum_{i=1}^k \frac{x_i - \bar{x}}{\sigma} &
z_2 = \frac{1}{n-k} \sum_{i=k+1}^n \frac{x_i - \bar{x}}{\sigma}. \\
\end{array}}{%
z[1] = 1 / k * \sum((x[1:k] - xmean) / \sigma) and
z[2] = (n - k) * (1 / (n - k) * \sum((x[(k+1):n] - xmean) / \sigma)).
}

The critical value is:
\deqn{T = \max T_k.}{T = \max(T[k]).} 

The \code{p.value} is estimated with a Monte Carlo simulation
using \code{m} replicates.

Critical values based on \eqn{m = 1,000,000} Monte Carlo simulations
are tabulated for \eqn{T} by Khaliq and Ouarda (2007).
}
\note{
The current function is for complete observations only.
}
\examples{
data(Nile)
(out <- snh.test(Nile))
plot(out)

data(PagesData) ; snh.test(PagesData)
 
}
\references{
H. Alexandersson (1986), A homogeneity test applied to precipitation data,
\emph{Journal of Climatology} 6, 661--675.

M. N. Khaliq, T. B. M. J. Ouarda (2007), On the critical values of the
standard normal homogeneity test (SNHT),
\emph{International Journal of Climatology} 27, 681--687.

G. Verstraeten, J. Poesen, G. Demaree, C. Salles (2006),
Long-term (105 years) variability in rain erosivity as derived from 10-min
rainfall depth data for Ukkel (Brussels, Belgium):
Implications for assessing soil erosion rates.
\emph{Journal of Geophysical Research} 111, D22109.
}
\seealso{
\code{\link[strucchange]{efp}}
\code{\link[strucchange]{sctest.efp}}
}
\keyword{htest}
\keyword{ts}
\keyword{univar}
