% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peps2.R
\name{peps2_run_sims}
\alias{peps2_run_sims}
\title{Run simulations of BEBOP in PePS2}
\usage{
peps2_run_sims(num_sims, sample_data_func, summarise_func, ...)
}
\arguments{
\item{num_sims}{integer, number of simulated iterations}

\item{sample_data_func}{delegate function that takes no parameters and
returns a list like \code{peps2_params}. This function is called
during each simulated iteration so it should contain random outcomes.}

\item{summarise_func}{delegate function that takes args \code{dat} and
\code{fit}, where \code{dat} is an instance of \code{peps2_params}
returned by \code{sample_data_func()}, and \code{fit} is an instance of
\code{rstan::stanmodel}, derived by sampling the BebopInPeps2 model. The
simulation routine collects this using
\code{stan::sampling(stanmodels$BebopInPeps2, data = dat)}. The objects
returned by this delegate are ultimately returned to the user. Thus, this
function should perform the post-processing to get the RStan sample into
some useful format. An example if \code{\link{peps2_process}}.}

\item{...}{extra parameters passed to \code{rstan::sampling}.}
}
\value{
a list of length \code{num_sims}, with element \code{i} being the
result of the \code{i}th call to \code{summarise_func(dat, fit)}.
}
\description{
Run simulations of the BEBOP model in a PePS2 scenario.
The logic of creating the data to be passed to the Stan model is delegated to
a function, thus the user may tailor rates of efficacy and toxicity, priors,
cohort membership probabilities, by specialising this function. Similarly,
the post-processing to perform on the RStan sample is delegated to another
function. This pattern gives a flexible interface.
}
\examples{
prob_eff <- c(0.167, 0.192, 0.5, 0.091, 0.156, 0.439)
prob_tox = c(0.1, 0.1, 0.1, 0.1, 0.1, 0.1)
peps2_scenario_data <- function() peps2_get_data(num_patients = 60,
                                                 prob_eff = prob_eff,
                                                 prob_tox = prob_tox,
                                                 eff_tox_or = rep(1, 6))
set.seed(123)
\dontrun{
sims <- peps2_run_sims(num_sims = 10, sample_data_func = peps2_scenario_data,
                       summarise_func = peps2_process)
apply(sapply(sims, function(x) x$Accept), 1, mean)  # 0.5 0.7 1.0 0.2 0.5 1.0
}
# Simulation suggests we are likely to approve in cohorts 3 and 6.
# In real life, we would run thousands of iterations, not 10.
# This is an example.

}
\seealso{
\code{\link{peps2_params}}

\code{\link{peps2_get_data}}

\code{\link{peps2_process}}
}
