% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffTox.R
\name{efftox_utility}
\alias{efftox_utility}
\title{Get the utility of efficacy & toxicity probability pairs}
\usage{
efftox_utility(p, eff0, tox1, prob_eff, prob_tox)
}
\arguments{
\item{p}{p-index of EffTox utility contours. Use \code{efftox_solve_p}}

\item{eff0}{Efficacy probability required when toxicity is impossible;
a number between 0 and 1}

\item{tox1}{Toxicity probability permitted when efficacy is guaranteed;
a number between 0 and 1}

\item{prob_eff}{Probability of efficacy; number between 0 and 1}

\item{prob_tox}{Probability of toxicity; number between 0 and 1}
}
\value{
Utility value(s)
}
\description{
Get the utility of efficacy & toxicity probability pairs
}
\examples{
p <- efftox_solve_p(0.5, 0.65, 0.7, 0.25)

u <- efftox_utility(p, 0.5, 0.65, prob_eff = 0.7, prob_tox = 0.25)
round(u, 4) == 0

u <- efftox_utility(p, 0.5, 0.65, prob_eff = c(0.6, 0.7, 0.8),
                    prob_tox = c(0.1, 0.2, 0.3))
round(u, 2) == c(0.04, 0.08, 0.12)

}
\seealso{
\code{\link{efftox_solve_p}}
}
