% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EffTox.R
\name{stan_efftox_demo}
\alias{stan_efftox_demo}
\title{Fit the EffTox model presented in Thall et al. (2014)}
\usage{
stan_efftox_demo(outcome_str, ...)
}
\arguments{
\item{outcome_str}{A string representing the outcomes observed hitherto.
See \code{\link{efftox_parse_outcomes}} for a description of syntax and
examples. Alternatively, you may provide \code{doses_given}, \code{eff} and
\code{tox} parameters. See Details.}

\item{...}{Extra parameters are passed to \code{rstan::sampling}. Commonly
used options are \code{iter}, \code{chains}, \code{warmup}, \code{cores},
\code{control}. \code{\link[rstan:sampling]{sampling}}.}
}
\value{
An object of class \code{\link{efftox_fit}}
}
\description{
Fit the EffTox model presented in Thall et al. (2014) using Stan for full
Bayesian inference.
}
\examples{
\dontrun{
# This model is presented in Thall et al. (2014)
mod2 <- stan_efftox_demo('1N 2E 3B', seed = 123)

# The seed is passed to the Stan sampler. The usual Stan sampler params like
# cores, iter, chains etc are passed on too via the ellipsis operator.
}
}
\references{
Thall, P., & Cook, J. (2004). Dose-Finding Based on Efficacy-Toxicity
    Trade-Offs. Biometrics, 60(3), 684-693.

  Thall, P., Herrick, R., Nguyen, H., Venier, J., & Norris, J. (2014).
    Effective sample size for computing prior hyperparameters in Bayesian
    phase I-II dose-finding. Clinical Trials, 11(6), 657-666.
    https://doi.org/10.1177/1740774514547397

  Brock, K., Billingham, L., Copland, M., Siddique, S., Sirovica, M., &
    Yap, C. (2017). Implementing the EffTox dose-finding design in the
    Matchpoint trial. BMC Medical Research Methodology, 17(1), 112.
    https://doi.org/10.1186/s12874-017-0381-x
}
\seealso{
\code{\link{efftox_fit}}
  \code{\link{stan_efftox}}
  \code{\link{efftox_process}}
}
\author{
Kristian Brock \email{kristian.brock@gmail.com}
}
