% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/absoluteRT.R
\name{absoluteRT}
\alias{absoluteRT}
\title{Absolute RT trimming}
\usage{
absoluteRT(data, minRT, maxRT, omitErrors = TRUE, returnType = "mean",
  digits = 3)
}
\arguments{
\item{data}{A data frame. It must contain columns named "participant",
"condition", "rt", and "accuracy". The RT can be in seconds
(e.g., 0.654) or milliseconds (e.g., 654). Typically, "condition" will
consist of strings. "accuracy" must be 1 for correct and 0 for error
responses.}

\item{minRT}{The lower criteria for acceptable response time. Must be in
the same form as rt column in data frame (e.g., in seconds OR milliseconds).}

\item{maxRT}{The upper criteria for acceptable response time. Must be in
the same form as rt column in data frame (e.g., in seconds OR milliseconds).}

\item{omitErrors}{If set to TRUE, error trials will be removed before
conducting trimming procedure. Final data returned will not be influenced
by errors in this case.}

\item{returnType}{Request nature of returned data. "raw" returns trial-
level data excluding trimmed data; "mean" returns mean response times per
participant for each experimental condition identified; "median" returns
median response times per participant for each experimental condition
identified.}

\item{digits}{How many decimal places to round to after trimming?}
}
\description{
\code{absoluteRT} takes a data frame of RT data and returns trimmed rt data
that fall between set minimum and maximum limits.
}
\details{
By passing a data frame containing raw response time data, together with
trimming criteria, the function will return trimmed data, either in the form
of trial-level data or in the form of means/medians for each subject &
condition.
}
\examples{
# load the example data that ships with trimr
data(exampleData)

# perform the trimming, returning mean RT
trimmedData <- absoluteRT(data = exampleData, minRT = 150, maxRT = 2500,
returnType = "mean")
}

