\name{trio.permTest}
\alias{trio.permTest}

\title{
Permutation Tests for Trio Logic Regression
}
\description{
Performs either a null-model or a conditional permutation test for a trio logic regression analysis. Corresponds to
the permutation tests done by \code{logreg} from the \code{LogicReg} package when setting the argument \code{select}
to \code{4} or \code{5}, respectively.
}
\usage{
trio.permTest(object, conditional = FALSE, n.perm = 10, nleaves = NULL, 
   anneal.control = NULL, rand = NA)
}

\arguments{
  \item{object}{an object of class \code{logreg}, i.e. the output of the function \code{\link[LogicReg]{logreg}}. This
     object must be the result of a trio logic regression analysis. For how such an object can be generated, see Details.
}
  \item{conditional}{should the conditional permutation test be performed? If \code{FALSE}, a null-model permutation test
    is done analogously to the null-model permutation test for population-based data available by setting \code{select = 4}
    in \code{\link[LogicReg]{logreg}}. If \code{TRUE}, a test analogous to the conditional permutation test for population-based
    data available by setting \code{select = 5} in \code{\link[LogicReg]{logreg}} is performed.
}
  \item{n.perm}{integer specifying the number of permutations.
}
  \item{nleaves}{integer specifying the maximum number of leaves that the logic tree in the trio logic regression model is allowed to have.
    If \code{NULL}, the maximum number of leaves saved in \code{object} is used.
}
  \item{anneal.control}{a list containing the values for the parameters of the simulated annealing underlying (trio) logic regression.
    For details, see \code{\link[LogicReg]{logreg.anneal.control}}. If \code{NULL}, the values saved in \code{object} are used.
}
  \item{rand}{an integer. If specified, the random number generator will be set into a reproducible state.
}
}

\details{
To perform a trio logic regression analysis, the \code{R} package \code{LogicReg} needs to be modified and recompiled. This can be
done as follows:

Download the package source of \code{LogicReg} from \url{http://cran.r-project.org/web/packages/LogicReg/index.html}, and extract it.

Replace the file \code{My_own_scoring.f} available in the subdirectory \code{src} of this package by the file \code{My_own_scoring.f}
  provided in the subdirectory \code{plugin} of the \code{trio} package.
  
Recompile the package using \code{R CMD build} (for more details, see 
  \url{http://cran.r-project.org/doc/manuals/R-exts.html#Checking-and-building-packages}), and install it.
  
Using \code{type = 0}, apply \code{\link[LogicReg]{logreg}} to binary trio data as, for example, generated by \code{\link{trio}} 
  (if \code{trio.out} is the output of \code{trio}, then in \code{logreg}, \code{resp = trio.out[["bin"]][,1]} and
  \code{bin = trio.out[["bin"]][,-1]}).
}

\value{
A list consisting of 
\item{origScore}{\code{NA}, if \code{conditional = FALSE}, and otherwise, the score, i.e.\ the value of the partial likelihood, 
   of the original model saved in \code{object}},
\item{permScore}{a vector of length \code{n.perm} containing the scores for the trio logic regression models built in the iterations
  of the permutation test.}
}
\references{
Li, Q., Fallin, M.D., Louis, T.A., Lasseter, V.K., McGrath, J.A., Avramopoulos, D., Wolyniec, P.S., Valle, D., Liang, K.Y., Pulver, A.E., 
and Ruczinski, I. (2010). Detection of SNP-SNP Interactions in Trios of Parents with Schizophrenic Children. Genetic Epidemiology, 34, 396-406. 
}
\author{
Qing Li, \email{mail2qing@yahoo.com}. Modified by Holger Schwender.
}

\seealso{
\code{\link{trio}}, \code{\link{trio.check}}, \code{\link[LogicReg]{logreg}} 
}

\keyword{htest}
\keyword{models}
