% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropicalsparse.mv.R
\name{tropicalsparse.mv}
\alias{tropicalsparse.mv}
\title{tropicalsparse.mv()}
\usage{
tropicalsparse.mv(alpha = NULL, A, opA = FALSE, x, beta = NULL, y,
  store = NULL, algebraType)
}
\arguments{
\item{alpha}{is a single real value.}

\item{A}{is a matrix.}

\item{opA}{is transpose of \code{A}.}

\item{x}{is a vector.}

\item{beta}{is a single real value.}

\item{y}{is a vector.}

\item{store}{is storage technique.}

\item{algebraType}{is string input that can be \code{minplus} or \code{maxplus}.}
}
\value{
Returns the resultant matrix.
}
\description{
\code{tropicalsparse.mv} function performs the matrix-vector operation on the equation: y = alpha * op(A) * x + beta * y.
}
\details{
The input of this function is one matrix, transpose of that matrix, two vectors, two constants,
storage technique and  type of Tropical Algebra. The inputs of the matrix, vectors and \code{algebraType} are
compulsory while all other inputs are optional. The matrix must be sparse otherwise error occured. \code{alpha}
and \code{beta} must be a single real value. \code{opA} can be set to TRUE to take transpose of \code{A}.
\code{store} input can be \code{coo}, \code{csc} and \code{csr} for applying following storage techniques
respectively: Coordinate-Wise, Compressed Sparse Row, Compressed Sparse Column. If \code{store} is not
specified then functionality is performed without using any storage technique. \code{algebraType} is used to
specify type of Tropical Algebra. This can be \code{minplus} or \code{maxplus}. For more details about
\code{algebraType}, see \code{detail} section of \code{\link{check.infinityM}} or \code{\link{check.infinityV}}.
First of all \code{A} is multiplied with \code{x} and if \code{alpha} is given then the product of \code{A}
and \code{x} will be multipied with \code{alpha} otherwise it remais the same. After this, \code{beta} is
multiplied with \code{y} only if \code{beta} is given. Finally, both result are added to each other and the
resultant matrix is obtained. Same functionailty is applied if any of the \code{store} technique is specified.
}
\examples{
a <- matrix(data = c(2, Inf, Inf, 0, Inf, Inf, Inf, 10, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

b <- c(2, Inf, 5)

c <- c(Inf, 9, Inf)

tropicalsparse.mv(A = a, alpha = 5, opA = TRUE, x = b, y = c,
store = 'csr', algebraType = 'minplus')

#      [,1] [,2] [,3]
# [1,]    9  Inf  Inf
# [2,]    9    9    9
# [3,]  Inf   20  Inf

}
