#include <Rcpp.h>
#include <R_ext/Applic.h>

using namespace Rcpp;

#ifndef __SURVIVAL_ANALYSIS__
#define __SURVIVAL_ANALYSIS__

NumericVector fsurvci(double surv, double sesurv, std::string ct, double z);

DataFrame survQuantile(const NumericVector& time, 
                       const IntegerVector& event,
                       const double cilevel, 
                       const std::string transform,
                       const NumericVector& probs);

DataFrame kmest(const DataFrame data,
                const StringVector& rep,
                const StringVector& stratum,
                const std::string time,
                const std::string time2,
                const std::string event,
                const std::string weight,
                const std::string conftype,
                const double conflev,
                const bool keep_censor);

DataFrame kmdiff(const DataFrame data,
                 const StringVector& rep,
                 const StringVector& stratum,
                 const std::string treat,
                 const std::string time,
                 const std::string event,
                 const double milestone,
                 const double survDiffH0,
                 const double conflev);

DataFrame lrtest(const DataFrame data,
                 const StringVector& rep,
                 const StringVector& stratum,
                 const std::string treat,
                 const std::string time,
                 const std::string time2,
                 const std::string event,
                 const std::string weight,
                 const double rho1,
                 const double rho2);

DataFrame rmest(const DataFrame data,
                const StringVector& rep,
                const StringVector& stratum,
                const std::string time,
                const std::string event,
                const double milestone,
                const double conflev,
                const bool biascorrection);

DataFrame rmdiff(const DataFrame data,
                 const StringVector& rep,
                 const StringVector& stratum,
                 const std::string treat,
                 const std::string time,
                 const std::string event,
                 const double milestone,
                 const double rmstDiffH0,
                 const double conflev,
                 const bool biascorrection);

struct aftparams {
  int dist_code; // 1: exponential, 2: weibull, 3: lognormal, 4: normal, 
                 // 5: loglogistic, 6: logistic
  IntegerVector strata;
  NumericVector tstart;
  NumericVector tstop;
  IntegerVector status;
  NumericVector weight;
  NumericVector offset;
  NumericMatrix z;
  int nstrata;
};


List f_der_1(int p, const NumericVector& par, void *ex);

NumericMatrix f_ressco_1(int p, const NumericVector& par, void *ex);

NumericMatrix f_jj_1(int p, const NumericVector& par, void *ex);

List liferegloop(int p, const NumericVector& par, void *ex,
                 int maxiter, double eps,
                 const IntegerVector& colfit, int ncolfit);

double liferegplloop(int p, const NumericVector& par, void *ex,
                     int maxiter, double eps,
                     int k, int which, double l0);

List f_ld_1(NumericVector eta, NumericVector sig, void *ex);

List liferegcpp(const DataFrame data,
                const StringVector& rep,
                const StringVector& stratum,
                const std::string time,
                const std::string time2,
                const std::string event,
                const StringVector& covariates,
                const std::string weight,
                const std::string offset,
                const std::string id,
                const std::string dist,
                const NumericVector& init,
                const bool robust,
                const bool plci,
                const double alpha,
                const int maxiter,
                const double eps);


NumericMatrix residuals_liferegcpp(const NumericVector& beta,
                                   const NumericMatrix& vbeta,
                                   DataFrame data,
                                   const StringVector& stratum,
                                   const std::string time,
                                   const std::string time2,
                                   const std::string event,
                                   const StringVector& covariates,
                                   const std::string weight,
                                   const std::string offset,
                                   const std::string id,
                                   const std::string dist,
                                   const std::string type,
                                   const bool collapse,
                                   const bool weighted);

struct coxparams {
  int nused;
  IntegerVector strata;
  NumericVector tstart;
  NumericVector tstop;
  IntegerVector event;
  NumericVector weight;
  NumericVector offset;
  NumericMatrix z;
  IntegerVector order1;
  int method; // 1: breslow, 2: efron
};


List f_der_2(int p, const NumericVector& par, void* ex, bool firth);

List phregloop(int p, const NumericVector& par, void *ex,
               int maxiter, double eps, bool firth,
               const IntegerVector& colfit, int ncolfit);

double phregplloop(int p, const NumericVector& par, void *ex,
                   int maxiter, double eps, bool firth,
                   int k, int which, double l0);

List f_basehaz(int p, const NumericVector& par, void *ex);

NumericMatrix f_ressco_2(int p, const NumericVector& par, void *ex);

NumericVector f_resmart(int p, const NumericVector& par, void *ex);

List f_ressch(int p, const NumericVector& par, void *ex);

List phregcpp(const DataFrame data,
              const StringVector& rep,
              const StringVector& stratum,
              const std::string time,
              const std::string time2,
              const std::string event,
              const StringVector& covariates,
              const std::string weight,
              const std::string offset,
              const std::string id,
              const std::string ties,
              const NumericVector& init,
              const bool robust,
              const bool est_basehaz,
              const bool est_resid,
              const bool firth,
              const bool plci,
              const double alpha,
              const int maxiter,
              const double eps);

DataFrame survfit_phregcpp(const int p,
                           const NumericVector& beta,
                           const NumericMatrix& vbeta,
                           DataFrame basehaz,
                           DataFrame newdata,
                           const StringVector& covariates,
                           const StringVector& stratum,
                           const std::string offset,
                           const std::string id,
                           const std::string tstart,
                           const std::string tstop,
                           const bool sefit,
                           const String conftype,
                           const double conflev);

List residuals_phregcpp(const int p,
                        const NumericVector& beta,
                        const NumericMatrix& vbeta,
                        const NumericVector& resmart,
                        DataFrame data,
                        const StringVector& stratum,
                        const std::string time,
                        const std::string time2,
                        const std::string event,
                        const StringVector& covariates,
                        const std::string weight,
                        const std::string offset,
                        const std::string id,
                        const std::string ties,
                        const std::string type,
                        const bool collapse,
                        const bool weighted);

#endif // __SURVIVAL_ANALYSIS__
