% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{eta2resp}
\alias{eta2resp}
\title{Simulate Ordinal Response Choices from Log Odds}
\usage{
eta2resp(eta, thresh)
}
\arguments{
\item{eta}{Predicted response tendency or tendencies on log odds scale.}

\item{thresh}{Cut-points (thresholds).}
}
\value{
A vector of the same length as \code{eta} with simulated
  integer response values, one for each \code{eta} value.
}
\description{
Simulate Ordinal Response Choices from Log Odds
}
\examples{
# N=10 with eta = 0 and 6 point scale from N&E
eta2resp(rep(0, 10), clmm_maximal$alpha)

# N=10 with eta = 0 and 7 point scale
eta2resp(rep(0, 10), alpha_6_to_7(clmm_maximal$alpha))

# N=10 with eta = 4 and 6 point scale from N&E
eta2resp(rep(4, 10), clmm_maximal$alpha)

# N=10 with eta = 4 and 7 point scale
eta2resp(rep(4, 10), alpha_6_to_7(clmm_maximal$alpha))

}
