% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_log_entry.R
\name{build.log.entry}
\alias{build.log.entry}
\title{Creates a log entry as a single \code{data.frame} row containing all relevant logging information in columns}
\usage{
build.log.entry(
  timestamp,
  severity,
  msg.text,
  execution.context.msg,
  call.stack,
  dump.file.name,
  omit.call.stack.items = 0
)
}
\arguments{
\item{timestamp}{logging timestamp as \code{\link{POSIXct}} (normally by calling \code{\link{Sys.time}})}

\item{severity}{severity level of the log entry ((ERROR, WARN, INFO etc.)}

\item{msg.text}{Logging message (e. g. error message)}

\item{execution.context.msg}{a text identifier (eg. the PID or a variable value) that will be appended to msg.text
for catched conditions. Must be a character or an error is thrown.}

\item{call.stack}{a call stack created by \code{\link{sys.calls}}}

\item{dump.file.name}{name of the created dump file (leave empty if the \code{\link{tryCatchLog}}
argument \code{write.error.dump.file} is \code{FALSE})}

\item{omit.call.stack.items}{the number of stack trace items to ignore (= last x calls) in
the passed \code{call.stack} since they are caused by using \code{tryCatchLog}}
}
\value{
An object of class \code{tryCatchLog.log.entry} and \code{\link{data.frame}} and the following columns:
        \enumerate{
        \item{timestamp   - creation date and time of the logging entry}
        \item{severity    - the serverity level of the log entry (ERROR, WARN, INFO etc.)}
        \item{msg.text    - the message text of the log entry}
        \item{compact.stack.trace - the short stack trace containing only entries with source code
                                    references down to line of code that has thrown the condition}
        \item{full.stack.trace    - the full stack trace with all calls down to the line of code that
                                    has thrown the condition (including calls to R internal functions
                                    and other functions even when the source code in not available).}
        \item{dump.file.name      - name of the created dump file (if any)}
        }
}
\description{
The serverity level should correspond to the condition class.
}
\note{
THIS IS A PACKAGE INTERNAL FUNCTION AND THEREFORE NOT EXPORTED.
}
\seealso{
\code{\link{last.tryCatchLog.result}}
              \code{\link{build.log.output}}
}
