% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_regular.R
\name{ts_regular}
\alias{ts_regular}
\title{Enforce Regularity}
\usage{
ts_regular(x, fill = NA)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.}

\item{fill}{instead of \code{NA}, an alternative value can be specified}
}
\description{
Enforces regularity in data frame and \code{xts} objects, by turning implicit
\code{NA}s into explicit \code{NA}s. In \code{ts} objects, regularity is automatically
enforced.
}
\examples{
x0 <- AirPassengers
x0[c(10, 15)] <- NA
x <- ts_na_omit(ts_dts(x0))
ts_regular(x)
ts_regular(x, fill = 0)

m <- mdeaths
m[c(10, 69)] <- NA
f <- fdeaths
f[c(1, 3, 15)] <- NA

ts_regular(ts_na_omit(ts_dts(ts_c(f, m))))
}
