% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.1.0.R
\name{tsforecast}
\alias{tsforecast}
\alias{get_forecast}
\alias{tsforecast.tsarima}
\alias{tsforecast.tsesm}
\alias{print.tsforecast}
\alias{plot.tsforecast}
\title{Forecast Time Series based on Fitted Models}
\usage{
## S3 method for default
tsforecast(object, n.ahead = 1, 
  alpha = 0.05, 
  show.plot = TRUE, 
  forecast.incl = c("all", "forecast", "predict"), 
  nobs.incl = NULL, 
  log = NULL, 
  newxreg = NULL, 
  x.name = NULL, pred.name = "Forecasts", ...)

\method{tsforecast}{tsarima}(object, ...)

\method{tsforecast}{tsesm}(object, ...)

\method{print}{tsforecast}(x, ...)

\method{plot}{tsforecast}(
  x,
  ylim = NULL,
  title = NULL,
  x.lwidth = 0.7,
  pred.lwidth = 0.7,
  x.col = "darkgrey",
  pred.col = "red",
  ci.col = "royalblue",
  ...
)
}
\arguments{
\item{object}{a time series or time series model for which forecasts are required.}

\item{n.ahead}{number of forecasting periods. Default is \code{1}.}

\item{alpha}{significance level. (1 - \code{alpha}) indicates is the confidence level of the prediction intervals. Default is \code{0.05}.}

\item{show.plot}{logical. If \code{TRUE}, forecasting plot will be displayed directly. Default is \code{TRUE}.}

\item{forecast.incl}{character string giving which part of the series should be predicted or forecasted. Default value is "\code{all}", which indicates that predicted values of the entire series, together with the forecasted values of the number of future periods specified with \code{n.ahead}, will be included. Specify with "\code{forecast}" if only forecasts of future periods should be included, and "\code{predict}" is used if only fitted values of past periods should be included in the output.}

\item{nobs.incl}{number of past observations for which the predicted values should be included in the output. If \code{forecast.incl} is set as "\code{forecast}", the value of this parameter will be ignored. Default is \code{NULL},}

\item{log}{optional. A logical value indicating whether the forecasted values are log-transformed and should be inverted back to the original series scale. If the object is an \code{tsarima} model and this parameter is omitted, the value will be taken over by the settings of the model given in object. Default is \code{NULL} here.}

\item{newxreg}{new values of the regressors. Only necessary if ARIMA model is built with independent variables.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{pred.name}{name of the forecasted series here. Default is `\code{Forecasts}`.}

\item{...}{additional arguments affecting the forecasts produced.}

\item{x}{an object of class `\code{tsforecast}`.}

\item{ylim}{value limit of the y-axis. The values should be specified in \code{c(lower_limit, upper_limit)}, where \code{lower_limit} and \code{upper_limit} are the values of the smallest and largest number of the y-axis, respectively. Default is \code{NULL}.}

\item{title}{title of the forecasting chart. Default is \code{NULL}.}

\item{x.lwidth}{line width of the original series in the output plot. Default is \code{0.7}.}

\item{pred.lwidth}{line width of the predicted past values or forecasted future values in the output plot. Default is \code{0.7}.}

\item{x.col}{colour of the original series in the output plot. Default is `\code{darkgrey}`.}

\item{pred.col}{colour of the predicted past values or forecasted future values in the output plot. Default is `\code{red}`.}

\item{ci.col}{colour of the forecasted prediction interval in the output plot. Default is `\code{royalblue}`.}
}
\value{
The function \code{print} is used to obtain and print the forecasting results, while the function \code{plot} produces a plot of the forecasts and prediction intervals.

An object of class "\code{tsforecast}" is a list usually containing the following elements:

\item{x}{original series data. Note that for future periods, no data can be displayed, and the corresponding cells are therefore blank.}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{pred}{predicted past values and forecasted future values.}

\item{pred.time}{list of time in which the predictions/forecasts were estimated.}

\item{pred.name}{name of the series containing the predicted/forecasted values.}

\item{se}{standard errors of the forecasted values. Note that standard errors are only calculated for future periods. The corresponding cells for past observations are therefore blank.}

\item{cil, ciu}{lower and upper limits of the prediction interval. Note that confidence (prediction) intervals are only calculated for future periods. The corresponding cells for past observations are therefore blank.}

\item{n.ahead}{number of forecasting periods.}

\item{forecast.incl}{indication of the series part that should be predicted or forecasted.}

\item{log}{logical. Indicates whether series values are log-transformed for model fitting or not.}

\item{alpha}{significance level.}
}
\description{
The generic function `\code{tsforecast}` is used for forecasting time series or time series models.
}
\examples{
tsforecast(tsarima(airport$Travellers, order = c(1, 1, 0), 
                   seasonal = c(0, 1, 1), log = TRUE, include.const = TRUE), 
           n.ahead = 6, forecast.incl = "all", nobs.incl = 12, 
           title = "Forecast of Travellers by ARIMA")

tsforecast(tsesm(airport$Travellers, order = "holt-winters"), 
           n.ahead = 6, title = "Forecast of Travellers by Holt-Winters")
}
\references{
Box, G. E. P., & Jenkins, G. M. (1970). Time series analysis: Forecasting and control. Holden-Day.

Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}
}
\author{
Ka Yui Karl Wu
}
