% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-na.R
\name{fill_na}
\alias{fill_na}
\title{Turn implicit missing values into explicit missing values}
\usage{
fill_na(.data, ...)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{A set of name-value pairs. The values will replace existing explicit
missing values by variable, otherwise \code{NA}. The replacement values must be of
the same type as the original one. If using a function to fill the \code{NA},
please make sure that \code{na.rm = TRUE} is switched on.}
}
\description{
Turn implicit missing values into explicit missing values
}
\examples{
harvest <- tsibble(
  year = c(2010, 2011, 2013, 2011, 2012, 2014),
  fruit = rep(c("kiwi", "cherry"), each = 3),
  kilo = sample(1:10, size = 6),
  key = id(fruit), index = year
)

# leave NA as is ----
full_harvest <- fill_na(harvest)
full_harvest

# use fill() to fill `NA` by previous/next entry
full_harvest \%>\% 
  group_by(fruit) \%>\% 
  fill(kilo, .direction = "down")

# replace NA with a specific value ----
harvest \%>\%
  fill_na(kilo = 0L)

# replace NA using a function by variable ----
# enable `na.rm = TRUE` when necessary ----
harvest \%>\%
  fill_na(kilo = sum(kilo, na.rm = TRUE))

# replace NA using a function for each group ----
harvest \%>\%
  group_by(fruit) \%>\%
  fill_na(kilo = sum(kilo, na.rm = TRUE))

# replace NA ----
pedestrian \%>\%
  group_by(Sensor) \%>\%
  fill_na(
    Date = lubridate::as_date(Date_Time),
    Time = lubridate::hour(Date_Time),
    Count = as.integer(median(Count, na.rm = TRUE))
  )
}
\seealso{
\link{case_na}, \link[tidyr:fill]{tidyr::fill}, \link[tidyr:replace_na]{tidyr::replace_na}
}
