% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsummarise.R
\name{tsummarise}
\alias{tsummarise}
\alias{tsummarise_all}
\alias{tsummarise_if}
\alias{tsummarise_at}
\alias{tsummarize}
\alias{tsummarize_all}
\alias{tsummarize_if}
\alias{tsummarize_at}
\title{Aggregate over calendar periods}
\usage{
tsummarise(.data, ...)

tsummarise_all(.data, ..., .funs)

tsummarise_if(.data, ..., .predicate, .funs)

tsummarise_at(.data, ..., .vars, .funs)

tsummarize(.data, ...)

tsummarize_all(.data, ..., .funs)

tsummarize_if(.data, ..., .predicate, .funs)

tsummarize_at(.data, ..., .vars, .funs)
}
\arguments{
\item{.data}{A data frame (of \code{tbl_ts} class).}

\item{...}{Name-value pairs of expressions. The index variable must be present
in the first name-value pair, with an index function. The remaining components
work like \code{summarise()}. For the scoped variants like \code{_all()}, \code{_at()}, \code{_if()},
additional arguments for the function call in \code{.funs} will be ignored in \code{...}.
The index functions that can be used, but not limited:
\itemize{
\item \link[lubridate:year]{lubridate::year}: yearly aggregation
\item \link{yearquarter}: quarterly aggregation
\item \link{yearmonth}: monthly aggregation
\item \link{yearweek}: weekly aggregation
\item \link{as.Date} or \link[lubridate:as_date]{lubridate::as_date}: daily aggregation
\item \link[lubridate:ceiling_date]{lubridate::ceiling_date}, \link[lubridate:floor_date]{lubridate::floor_date}, or \link[lubridate:round_date]{lubridate::round_date}:
sub-daily aggregation
\item other index functions from other packages
}}

\item{.funs}{List of function calls generated by \code{\link[=funs]{funs()}}, or a
character vector of function names, or simply a function.

Bare formulas are passed to \code{\link[rlang:as_function]{rlang::as_function()}} to create
purrr-style lambda functions. Note that these lambda prevent
hybrid evaluation from happening and it is thus more efficient to
supply functions like \code{mean()} directly rather than in a
lambda-formula.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}
}
\description{
It computes summary statistics for a tsibble over calendar periods, usually
used in combination of \code{group_by}.
}
\details{
\itemize{
\item For a grouped tsibble, the rightmost grouping variable will be dropped
after the operation.
\item The scoped variants only operate on the non-key and non-index variables.
}
}
\seealso{
\link[dplyr:summarise_all]{dplyr::summarise_all}
}
