% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr-verbs.R
\name{unnest.lst_ts}
\alias{unnest.lst_ts}
\title{Unnest a list column.}
\usage{
\method{unnest}{lst_ts}(data, ..., key = id(), .drop = NA, .id = NULL,
  .sep = NULL, .preserve = NULL)
}
\arguments{
\item{data}{A \code{lst_ts}.}

\item{...}{Specification of columns to unnest. Use bare variable names or
functions of variables. If omitted, defaults to all list-cols.}

\item{key}{Unquoted variables to create the key (via \link{id}) after unnesting.}

\item{.drop}{Should additional list columns be dropped? By default,
\code{unnest} will drop them if unnesting the specified columns requires
the rows to be duplicated.}

\item{.id}{Data frame identifier - if supplied, will create a new column
with name \code{.id}, giving a unique identifier. This is most useful if
the list column is named.}

\item{.sep}{If non-\code{NULL}, the names of unnested data frame columns
will combine the name of the original list-col with the names from
nested data frame, separated by \code{.sep}.}

\item{.preserve}{Optionally, list-columns to preserve in the output. These
will be duplicated in the same way as atomic vectors. This has
\link[dplyr:select]{dplyr::select} semantics so you can preserve multiple variables with
\code{.preserve = c(x, y)} or \code{.preserve = starts_with("list")}.}
}
\value{
A \code{tbl_ts}.
}
\description{
Unnest a list column.
}
\examples{
nested_ped <- pedestrian \%>\% 
  nest(-Sensor)
nested_ped \%>\% 
  unnest(key = id(Sensor))
nested_tourism <- tourism \%>\% 
  nest(-Region, -State)
nested_tourism \%>\% 
  unnest(key = id(Region | State))
}
\seealso{
\link[tidyr:unnest]{tidyr::unnest}, \link{nest.tbl_ts} for the inverse operation.
}
