% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.R
\name{append_row}
\alias{append_row}
\alias{append_case}
\title{Append rows to a tsibble}
\usage{
append_row(.data, n = 1L)
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{n}{An integer indicates the number of key-index pair to append.}
}
\description{
Add new rows to the end of a tsibble by filling a key-index pair and \code{NA} for
measured variables.
}
\details{
\code{append_case()} is an alias of \code{append_row()}.
}
\examples{
tsbl <- tsibble(
  date = rep(as.Date("2017-01-01") + 0:2, each = 2), 
  group = rep(letters[1:2], 3),
  value = rnorm(6),
  key = id(group)
)
append_row(tsbl)
append_row(tsbl, n = 2)
}
