% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tourism}
\alias{tourism}
\title{Australian domestic overnight trips}
\format{A tsibble with 23,408 rows and 5 variables:
\itemize{
\item \strong{Quarter}: Year quarter (index)
\item \strong{Region}: The tourism regions are formed through the aggregation of
Statistical Local Areas (SLAs) which are defined by the various State and
Territory tourism authorities according to their research and marketing
needs
\item \strong{State}: States and territories of Australia
\item \strong{Purpose}: Stopover purpose of visit:
\itemize{
\item "Holiday"
\item "Visiting friends and relatives"
\item "Business"
\item "Other reason"
}
\item \strong{Trips}: Overnight trips in thousands
}}
\usage{
tourism
}
\description{
A dataset containing the quarterly overnight trips from 1998 Q1 to 2016 Q4
across Australia.
}
\examples{
data(tourism)
# Total trips over geographical regions
tourism \%>\% 
  group_by(Region, State) \%>\% 
  summarise(Total_Trips = sum(Trips))
}
\references{
\href{https://www.tra.gov.au}{Tourism Research Australia}
}
\keyword{datasets}
