% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{as.matrixprofile}
\alias{as.matrixprofile}
\alias{as.multimatrixprofile}
\alias{as.fluss}
\alias{as.chain}
\alias{as.motif}
\alias{as.multimotif}
\alias{as.arccount}
\alias{as.salient}
\title{Convert a TSMP object into another if possible}
\usage{
as.matrixprofile(.mp)

as.multimatrixprofile(.mp)

as.fluss(.mp)

as.chain(.mp)

as.motif(.mp)

as.multimotif(.mp)

as.arccount(.mp)

as.salient(.mp)
}
\arguments{
\item{.mp}{a TSMP object.}
}
\value{
Returns the object with the new class, if possible.
}
\description{
The base Classes are \code{MatrixProfile} and \code{MultiMatrixProfile}, but as other functions are used,
classes are pushed behind, since the last output normally is the most significant. If you want,
for example, to plot the Matrix Profile from a \code{Fluss} object, you may use \code{as.matrixprofile()}
to cast it back.
}
\section{Functions}{
\itemize{
\item \code{as.matrixprofile}: Cast an object changed by another function back to \code{MatrixProfile}.

\item \code{as.multimatrixprofile}: Cast an object changed by another function back to \code{MultiMatrixProfile}.

\item \code{as.fluss}: Cast an object changed by another function back to \code{Fluss}.

\item \code{as.chain}: Cast an object changed by another function back to \code{Chain}.

\item \code{as.motif}: Cast an object changed by another function back to \code{Motif}.

\item \code{as.multimotif}: Cast an object changed by another function back to \code{MultiMotif}.

\item \code{as.arccount}: Cast an object changed by another function back to \code{ArcCount}.

\item \code{as.salient}: Cast an object changed by another function back to \code{Salient}.
}}

\examples{

w <- 50
data <- mp_gait_data
mp <- tsmp(data, window_size = w, exclusion_zone = 1/4, verbose = 0)
mp <- find_motif(mp)
class(mp) # first class will be "Motif"

plot(mp) # plots a motif plot

plot(as.matrixprofile(mp)) # plots a matrix profile plot

}
