% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_svm.R
\name{ts_svm}
\alias{ts_svm}
\title{SVM}
\usage{
ts_svm(
  preprocess = NA,
  input_size = NA,
  kernel = "radial",
  epsilon = 0,
  cost = 10
)
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{kernel}{SVM kernel (linear, radial, polynomial, sigmoid)}

\item{epsilon}{error threshold}

\item{cost}{this parameter controls the trade-off between achieving a low error on the training data and minimizing the model complexity}
}
\value{
returns a \code{ts_svm} object.
}
\description{
Creates a time series prediction object that
uses the Support Vector Machine (SVM).
It wraps the e1071 library.
}
\examples{
library(daltoolbox)
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_svm(ts_norm_gminmax(), input_size=4)
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
