% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_maintune.R
\name{ts_maintune}
\alias{ts_maintune}
\title{Time Series Tune}
\usage{
ts_maintune(
  input_size,
  base_model,
  folds = 10,
  preprocess = list(ts_norm_gminmax()),
  augment = list(ts_aug_none())
)
}
\arguments{
\item{input_size}{input size for machine learning model}

\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}

\item{preprocess}{list of preprocessing methods}

\item{augment}{data augmentation method}
}
\value{
a \code{ts_maintune} object.
}
\description{
Time Series Tune
}
\examples{
library(daltoolbox)
data(tsd)
ts <- ts_data(tsd$y, 10)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

tune <- ts_maintune(input_size=c(3:5), base_model = ts_elm(), preprocess = list(ts_norm_gminmax()))
ranges <- list(nhid = 1:5, actfun=c('purelin'))

# Generic model tunning
model <- fit(tune, x=io_train$input, y=io_train$output, ranges)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
