% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ts.R
\name{read_ts}
\alias{read_ts}
\title{Import time series data from a file.}
\usage{
read_ts(
  file,
  format = c("csv", "xlsx", "json", "zip"),
  sep = ",",
  skip = 0,
  column_names = c("date", "value", "series"),
  keep_last_freq_only = FALSE,
  force_xts = FALSE
)
}
\arguments{
\item{file}{Path to the file to be read}

\item{format}{Which file format is the data stored in? If no format is supplied, read_ts will attempt to guess
from the file extension.}

\item{sep}{character seperator for csv files. defaults to ','.}

\item{skip}{numeric See data.table's fread.}

\item{column_names}{character vector denoting column names, defaults to c("date","value","series).}

\item{keep_last_freq_only}{in case there is a frequency change in a time series,
should only the part of the series be returned that has the same frequency as
the last observation. This is useful when data start out crappy and then stabilize
after a while. Defaults to FALSE. Hence only the last part of the series is returned.}

\item{force_xts}{If set to true, the time series will be returned as xts objects regargless of
regularity. Setting this to TRUE means keep_last_freq_only is ignored.}
}
\value{
A named list of ts objects
}
\description{
If importing from a zip file, the archive should contain a single file with the extension .csv, .xlsx or .json.
}
