% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp.R
\name{decomp}
\alias{decomp}
\title{Classical time series decomposition}
\usage{
decomp(y, m = NULL, s = NULL, trend = NULL, outplot = c(FALSE,
  TRUE), decomposition = c("multiplicative", "additive", "auto"),
  h = 0, type = c("mean", "median", "pure.seasonal"), w = NULL)
}
\arguments{
\item{y}{input time series. Can be \code{ts} object.}

\item{m}{seasonal period. If \code{y} is a \code{ts} object then the default is its frequency.}

\item{s}{starting period in the season. If \code{y} is a \code{ts} object then this is picked up from \code{y}.}

\item{trend}{vector of the level/trend of \code{y}. Use \code{NULL} to estimate internally.}

\item{outplot}{if \code{TRUE}, then provide a plot of the decomposed components.}

\item{decomposition}{type of decomposition. This can be \code{"multiplicative"}, \code{"additive"} or \code{"auto"}. If \code{y} contains non-positive values then this is forced to \code{"additive"}.}

\item{h}{forecast horizon for seasonal component.}

\item{type}{calculation for seasonal component:
\itemize{
\item{\code{"mean"}}{: the mean of each seasonal period.}
\item{\code{"median"}}{: the median of each seasonal period.}
\item{\code{"pure.seasonal"}}{: estimate using a pure seasonal model.}
}}

\item{w}{percentage or number of observations to winsorise in the calculation of mean seasonal indices. If w>1 then it is the number of observations, otherwise it is a percentage. If \code{type != "mean"} then this is ignored.}
}
\value{
A list containing:
\itemize{
\item{\code{trend}}{: trend component.}
\item{\code{season}}{: season component.}
\item{\code{irregular}}{: irregular component.}
\item{\code{f.season}}{: forecasted seasonal component if \code{h>0}.}
\item{\code{g}}{: pure seasonal model parameters.}
}
}
\description{
Perform classical time series decomposition.
}
\examples{
decomp(referrals)

}
\references{
Ord K., Fildes R., Kourentzes N. (2017) \href{http://kourentzes.com/forecasting/2017/10/16/new-forecasting-book-principles-of-business-forecasting-2e/}{Principles of Business Forecasting, 2e}. \emph{Wessex Press Publishing Co.}, p.106-111.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
