% Generated by roxygen2 (4.0.1): do not edit by hand
\name{triplicate}
\alias{triplicate}
\title{Find Triplicate Values}
\usage{
triplicate(x)
}
\arguments{
\item{x}{A vector.}
}
\description{
Finds values that occur exactly three times in a vector.
}
\details{
Returns the triplicated values in the same order that they would be
returned in a call to \code{\link[tuple]{orphan}}.  This fundamentally
differs from \code{\link[tuple]{triplicated}}, which returns
a logical vector that is \code{TRUE} when it runs into any but
the first or second occurrences of a value (and is therefore
dependent on the direction of testing of the vector).
}
\examples{
triplicate(c(NA, 1:3, 3, 4:6, 3, NA, 4))
triplicate(c(NA, 1:3, 3, 4:6, 3, NA, 4, 3))
}
\author{
Emmanuel Lazaridis <emmanuel@lazaridis.eu>
}
\seealso{
\code{\link[base]{duplicated}}
}
\keyword{repeat,}
\keyword{repeated}
\keyword{triplicate,}
\keyword{triplicated,}

