% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_tvem.R
\name{select_tvem}
\alias{select_tvem}
\title{select_tvem:  Select number of interior knots for an unpenalized TVEM.}
\usage{
select_tvem(
  max_knots = 5,
  keep_going_if_too_few = FALSE,
  use_bic = FALSE,
  penalize = FALSE,
  print_output = TRUE,
  ...
)
}
\arguments{
\item{max_knots}{The maximum number of interior knots to try (0 through max_knots)}

\item{keep_going_if_too_few}{Whether to continue in a stepwise fashion if the max_knots 
does not seem to be high enough}

\item{use_bic}{Whether to use BIC (TRUE) instead of AIC (FALSE) when selecting the best 
model. Note that both of these IC's are calculated from the working-independence 
pseudolikelihood rather than the unknown true likelihood. However, for BIC, the
sample size is taken to be the number of subjects, not the number of observations.}

\item{penalize}{Whether to include a penalty function in estimation}

\item{print_output}{Whether to print the pseudolikelihoods obtained for each candidate number of interior knots.}

\item{...}{Other inputs to be sent along to each call to the tvem function.}
}
\value{
A TVEM object for the fitted model, with an additional component containing
a table of information criteria.
}
\description{
select_tvem:  Select number of interior knots for an unpenalized TVEM.
}
\examples{
set.seed(123)
the_data <- simulate_tvem_example(n_subjects=200)
tvem_model <- tvem(data=the_data,
              formula=y~1,
              id=subject_id,
              time=time)
print(tvem_model)
plot(tvem_model)

}
