% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvmb.R
\name{tvmb}
\alias{tvmb}
\title{Time Varying Mediation Function: Binary Outcome and Two Treatment Groups}
\usage{
tvmb(
  treatment,
  t.seq,
  mediator,
  outcome,
  span = 0.75,
  plot = FALSE,
  CI = "boot",
  replicates = 1000,
  verbose = FALSE
)
}
\arguments{
\item{treatment}{a vector indicating treatment group}

\item{t.seq}{a vector of unique time points for each observation}

\item{mediator}{matrix of mediator values in wide format}

\item{outcome}{matrix of outcome values in wide format}

\item{span}{Numeric value of the span to be used for LOESS regression. Default = 0.75.}

\item{plot}{TRUE or FALSE for producing plots. Default = "FALSE". (OPTIONAL ARGUMENT)}

\item{CI}{"none" or "boot" method of deriving confidence intervals. Default = "boot". (OPTIONAL ARGUMENT)}

\item{replicates}{Number of replicates for bootstrapping confidence intervals. Default = 1000. (OPTIONAL ARGUMENT)}

\item{verbose}{TRUE or FALSE for printing results to screen. Default = "FALSE". (OPTIONAL ARGUMENT)}
}
\value{
\item{timeseq}{time points of estimation}

\item{alpha_hat}{estimated treatment effect on mediator}

\item{CI.lower.a}{CI lower limit for estimated coefficient alpha_hat}

\item{CI.upper.a}{CI upper limit for estimated coefficient alpha_hat}

\item{gamma_hat}{estimated treatment effect on outcome (direct effect)}

\item{CI.lower.g}{CI lower limit for estimated coefficient gamma_hat}

\item{CI.upper.g}{CI upper limit for estimated coefficient gamma_hat}

\item{beta_hat}{estimated mediator effect on outcome}

\item{CI.lower.b}{CI lower limit for estimated coefficient beta_hat}

\item{CI.upper.b}{CI upper limit for estimated coefficient beta_hat}

\item{tau_hat}{estimated treatment effect on outcome (total effect)}

\item{CI.lower.t}{CI lower limit for estimated coefficient tau_hat}

\item{CI.upper.t}{CI upper limit for estimated coefficient tau_hat}

\item{medEffect}{time varying mediation effect}

\item{CI.lower}{CI lower limit for medEffect}

\item{CI.upper}{CI upper limit for medEffect}
}
\description{
Function to estimate the time-varying mediation effect and bootstrap standard errors, involving two treatment groups and binary outcome.
}
\note{
\enumerate{
\item{Currently supports 2 treatment groups}
\item{** IMPORTANT ** An alternate way of formatting the data and calling the function 
      is documented in detail in the tutorial for the tvmb() function.}
}
}
\section{Plot Returns}{

\enumerate{
\item{\code{plot1_a }}{plot for alpha_hat with CIs over t.seq}
\item{\code{plot2_g }}{plot for gamma_hat with CIs over t.seq}
\item{\code{plot3_b }}{plot for beta_hat with CIs over t.seq}
\item{\code{plot4_t }}{plot for tau_hat with CIs over t.seq}
\item{\code{MedEff }}{plot for medEffect over t.seq}
\item{\code{MedEff_CI }}{plot for medEffect with CIs over t.seq}
\item{\code{bootstrap }}{plot for estimated medEffect from bootstrapped samples over t.seq}
}
}

\examples{
\dontrun{data(smoker)

# REDUCE DATA SET TO ONLY 2 TREATMENT CONDITIONS (EXCLUDE COMBINATION NRT)
smoker.sub <- smoker[smoker$treatment != 4, ]

# GENERATE WIDE FORMATTED MEDIATORS
mediator <- LongToWide(smoker.sub$SubjectID,
                       smoker.sub$timeseq,
                       smoker.sub$NegMoodLst15min)

# GENERATE WIDE FORMATTED OUTCOMES
outcome <- LongToWide(smoker.sub$SubjectID,
                      smoker.sub$timeseq,
                      smoker.sub$smoke_status)

# GENERATE A BINARY TREATMENT VARIABLE
trt <- as.numeric(unique(smoker.sub[, c("SubjectID","varenicline")])[, 2])-1

# GENERATE A VECTOR OF UNIQUE TIME POINTS
t.seq <- sort(unique(smoker.sub$timeseq))

# COMPUTE TIME VARYING MEDIATION ANALYSIS USING BOOTSTRAPPED CONFIDENCE INTERVALS
results <- tvmb(trt, t.seq, mediator, outcome)}

}
\references{
\enumerate{
\item{Fan, J. and Gijbels, I. Local polynomial modelling and its 
      applications: Monographs on statistics and applied probability 66. 
      CRC Press; 1996.}
\item{Fan J, Zhang W. Statistical Estimation in Varying Coefficient Models. 
      The Annals of Statistics. 1999;27(5):1491-1518.}
\item{Fan J, Zhang JT. Two-step estimation of functional linear models with 
      applications to longitudinal data. Journal of the Royal Statistical Society: 
      Series B (Statistical Methodology). 2000;62(2):303-322.}
\item{Baker TB, Piper ME, Stein JH, et al. Effects of Nicotine Patch vs Varenicline 
      vs Combination Nicotine Replacement Therapy on Smoking Cessation at 26 Weeks: 
      A Randomized Clinical Trial. JAMA. 2016;315(4):371.}
\item{B. Efron, R. Tibshirani. Bootstrap Methods for Standard Errors, Confidence 
      Intervals, and Other Measures of Statistical Accuracy. Statistical Science. 
      1986;1(1):54-75.}
}
}
