% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parksAndRec_palette.R
\name{parksAndRec_pal}
\alias{parksAndRec_pal}
\alias{scale_color_parksAndRec}
\alias{scale_colour_parksAndRec}
\alias{scale_fill_parksAndRec}
\title{Parks & Recreation palette}
\usage{
parksAndRec_pal(n, type = c("discrete", "continuous"), reverse = FALSE)

scale_color_parksAndRec(n, type = "discrete", reverse = FALSE, ...)

scale_colour_parksAndRec(n, type = "discrete", reverse = FALSE, ...)

scale_fill_parksAndRec(n, type = "discrete", reverse = FALSE, ...)
}
\arguments{
\item{n}{number of colors}

\item{type}{discrete or continuous}

\item{reverse}{reverse order, Default: FALSE}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:hue_pal]{scales::hue_pal()}}).}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{limits}}{A character vector that defines possible values of the scale
and their order.}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what value aesthetic
value should missing be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\description{
Parks & Recreation palette
}
\examples{
library(scales)
show_col(parksAndRec_pal()(5))

library(ggplot2)
ggplot(airquality, aes(x = Day, y = Temp,
     group = as.factor(Month), color = as.factor(Month))) +
     geom_point(size = 2.5) +
     scale_color_parksAndRec()

ggplot(airquality, aes(x = Day, y = Temp,
     group = as.factor(Month), color = as.factor(Month))) +
     geom_point(size = 2.5) +
     scale_colour_parksAndRec()

ggplot(mpg, aes(displ)) +
     geom_histogram(aes(fill = class), col = "black", size = 0.1) +
     scale_fill_parksAndRec()
}
