% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{cvm_stat}
\alias{cvm_stat}
\alias{cvm_test}
\title{Cramer-von Mises Test}
\usage{
cvm_stat(a, b, power = 2)

cvm_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
A two-sample test based on the Cramer-Von Mises test statistic (\code{cvm_stat}).
}
\details{
The CVM test compares two ECDFs by looking at the sum of the squared differences between them -- evaluated at each point in the joint sample. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then \deqn{CVM = \sum_{x\in k}|E(x)-F(x)|^p}{CVM = SUM_(x in k) |E(x)-F(x)|^p} where k is the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample. Intuitively the CVM test improves on KS by using the full joint sample, rather than just the maximum distance -- this gives it greater power against shifts in higher moments, like variance changes.

In the example plot below, the CVM statistic is the sum of the heights of the vertical black lines. \figure{cvm.png}{Example CVM stat plot}
}
\section{Functions}{
\itemize{
\item \code{cvm_stat}: Cramer-Von Mises Test statistic

\item \code{cvm_test}: Permutation based two sample Cramer-Von Mises test
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
cvm_test(vec1,vec2)
}
\seealso{
\code{\link[=dts_test]{dts_test()}} for a more powerful test statistic. See \code{\link[=ks_test]{ks_test()}} or \code{\link[=kuiper_test]{kuiper_test()}} for the predecessors to this test statistic. See \code{\link[=wass_test]{wass_test()}} and \code{\link[=ad_test]{ad_test()}} for the successors to this test statistic.
}
