% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/documentation.R,
%   R/two_samples.R
\name{ad_stat}
\alias{ad_stat}
\alias{ad_test}
\title{Anderson-Darling Test}
\usage{
ad_stat(a, b, power = 2)

ad_test(a, b, nboots = 2000, p = default.p)
}
\arguments{
\item{a}{a vector of numbers (or factors -- see details)}

\item{b}{a vector of numbers}

\item{power}{power to raise test stat to}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
A two-sample test based on the Anderson-Darling test statistic (\code{ad_stat}).
}
\details{
The AD test compares two ECDFs by looking at the weighted sum of the squared differences between them -- evaluated at each point in the joint sample. The weights are determined by the variance of the joint ECDF at that point, which peaks in the middle of the joint distribution (see figure below). Formally -- if E is the ECDF of sample 1, F is the ECDF of sample 2, and G is the ECDF of the joint sample then \deqn{AD = \sum_{x \in k} \left({|E(x)-F(x)| \over \sqrt{2G(x)(1-G(x))/n} }\right)^p }{AD =  SUM_(x in k) (|E(x)-F(x)|/sqrt(2G(x)*(1-G(x)))/n)^p} where k is the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample. Intuitively the AD test improves on the CVM test by giving lower weight to noisy observations.

In the example plot below, we see the variance of the joint ECDF over the range of the data. It clearly peaks in the middle of the joint sample.

\figure{var.png}{Plot of Variance of joint ECDF}

In the example plot below, the AD statistic is the weighted sum of the heights of the vertical lines, where weights are represented by the shading of the lines.

\figure{ad.png}{Example AD stat plot}

Inputs \code{a} and \code{b} can also be vectors of ordered (or unordered) factors, so long as both have the same levels and orderings. When possible, ordering factors will substantially increase power.
}
\section{Functions}{
\itemize{
\item \code{ad_stat}: Anderson-Darling Test statistic

\item \code{ad_test}: Permutation based two sample Anderson-Darling test
}}

\examples{
vec1 = rnorm(20)
vec2 = rnorm(20,4)
ad_test(vec1,vec2)

# Example using ordered factors
vec1 = factor(LETTERS[1:5],levels = LETTERS,ordered = TRUE)
vec2 = factor(LETTERS[c(1,2,2,2,4)],levels = LETTERS, ordered=TRUE)
ad_test(vec1,vec2)
}
\seealso{
\code{\link[=dts_test]{dts_test()}} for a more powerful test statistic. See \code{\link[=cvm_test]{cvm_test()}} for the predecessor to this test statistic. See \code{\link[=dts_test]{dts_test()}} for the natural successor to this test statistic.
}
