% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txtq.R
\name{R6_txtq}
\alias{R6_txtq}
\title{R6 class for \code{txtq} objects}
\description{
See the \code{\link[=txtq]{txtq()}} function for full documentation and usage.
}
\seealso{
txtq
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{R6_txtq$new()}}
\item \href{#method-path}{\code{R6_txtq$path()}}
\item \href{#method-count}{\code{R6_txtq$count()}}
\item \href{#method-total}{\code{R6_txtq$total()}}
\item \href{#method-empty}{\code{R6_txtq$empty()}}
\item \href{#method-log}{\code{R6_txtq$log()}}
\item \href{#method-list}{\code{R6_txtq$list()}}
\item \href{#method-pop}{\code{R6_txtq$pop()}}
\item \href{#method-push}{\code{R6_txtq$push()}}
\item \href{#method-reset}{\code{R6_txtq$reset()}}
\item \href{#method-clean}{\code{R6_txtq$clean()}}
\item \href{#method-destroy}{\code{R6_txtq$destroy()}}
\item \href{#method-validate}{\code{R6_txtq$validate()}}
\item \href{#method-import}{\code{R6_txtq$import()}}
\item \href{#method-clone}{\code{R6_txtq$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a txtq.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$new(path, use_lock_file = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Character string giving the file path of the queue.
The \code{txtq()} function creates a folder at this path to store
the messages.}

\item{\code{use_lock_file}}{Logical, whether to use a lock file
for blocking operations. Should only be \code{FALSE} in specialized
use cases with no parallel computing (for example, when a
\code{txtq} is used as a database and accessed by only one process.)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path"></a>}}
\if{latex}{\out{\hypertarget{method-path}{}}}
\subsection{Method \code{path()}}{
Get the txtq path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$path()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-count"></a>}}
\if{latex}{\out{\hypertarget{method-count}{}}}
\subsection{Method \code{count()}}{
Get the number of messages in the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$count()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-total"></a>}}
\if{latex}{\out{\hypertarget{method-total}{}}}
\subsection{Method \code{total()}}{
Get the number of messages in the database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$total()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-empty"></a>}}
\if{latex}{\out{\hypertarget{method-empty}{}}}
\subsection{Method \code{empty()}}{
Detect whether the txtq is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log"></a>}}
\if{latex}{\out{\hypertarget{method-log}{}}}
\subsection{Method \code{log()}}{
List the whole database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$log()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list"></a>}}
\if{latex}{\out{\hypertarget{method-list}{}}}
\subsection{Method \code{list()}}{
List messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$list(n = -1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pop"></a>}}
\if{latex}{\out{\hypertarget{method-pop}{}}}
\subsection{Method \code{pop()}}{
Pop messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$pop(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-push"></a>}}
\if{latex}{\out{\hypertarget{method-push}{}}}
\subsection{Method \code{push()}}{
Push messages.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$push(title, message)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{Titles of the messages.}

\item{\code{message}}{Contents of the messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the txtq.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean"></a>}}
\if{latex}{\out{\hypertarget{method-clean}{}}}
\subsection{Method \code{clean()}}{
Clean the txtq.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$clean()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-destroy"></a>}}
\if{latex}{\out{\hypertarget{method-destroy}{}}}
\subsection{Method \code{destroy()}}{
Destroy the txtq.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$destroy()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-validate"></a>}}
\if{latex}{\out{\hypertarget{method-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the txtq.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$validate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-import"></a>}}
\if{latex}{\out{\hypertarget{method-import}{}}}
\subsection{Method \code{import()}}{
Import another txtq.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$import(queue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{queue}}{External txtq to import.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_txtq$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
