% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwr.confIntProp.R
\name{pwr.confIntProp}
\alias{pwr.confIntProp}
\title{Estimate required sample size for accuracy in parameter estimation of a proportion}
\usage{
pwr.confIntProp(prop, conf.level = 0.95, w = 0.1, silent = TRUE)
}
\arguments{
\item{prop}{The proportion you expect to find, or a vector of proportions to
enable easy sensitivity analyses.}

\item{conf.level}{The confidence level of the desired confidence interval.}

\item{w}{The desired 'halfwidth' of the confidence interval.}

\item{silent}{Whether to provide a lot of information about progress
('FALSE') or not ('TRUE').}
}
\value{
A single numeric value (the sample size).
}
\description{
This function uses \code{\link[=confIntProp]{confIntProp()}} to compute the required sample size for
estimating a proportion with a given accuracy.
}
\examples{
### Required sample size to estimate a prevalence of .03 in the
### population with a confidence interval of a maximum half-width of .01
pwr.confIntProp(.03, w=.01);

### Vectorized over prop, so you can easily see how the required sample
### size varies as a function of the proportion
pwr.confIntProp(c(.03, .05, .10), w=.01);
}
