% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggSave.R
\name{ggSave}
\alias{ggSave}
\title{Save a ggplot with specific defaults}
\usage{
ggSave(
  file = NULL,
  plot = ggplot2::last_plot(),
  width = ufs::opts$get("ggSaveFigWidth"),
  height = ufs::opts$get("ggSaveFigHeight"),
  units = ufs::opts$get("ggSaveUnits"),
  dpi = ufs::opts$get("ggSaveDPI"),
  device = NULL,
  type = NULL,
  bg = "transparent",
  preventType = ufs::opts$get("ggSavePreventType"),
  ...
)
}
\arguments{
\item{file}{The file where to save to.}

\item{plot}{The plot to save; if omitted, the last drawn plot is saved.}

\item{height, width}{The dimensions of the plot, specified in \code{units}.}

\item{units}{The units, \code{'cm'}, '\code{mm}', or \code{'in'}.}

\item{dpi}{The resolution (dots per inch). This argument is vectorized.}

\item{device}{The graphic device; is inferred from the file if not specified.}

\item{type}{An additional arguments for the graphic device.}

\item{bg}{The background (e.g. 'white').}

\item{preventType}{Whether to prevent passing a value for the \code{type} argument
to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}. This is prevented by default since \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} switched
to using the ragg device by default, resulting in throwing a warning
("Warning: Using ragg device as default. Ignoring \code{type} and \code{antialias} arguments")
if something if passed for 'type'.}

\item{...}{Any additional arguments are passed on to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}
}
\value{
The plot, invisibly.
}
\description{
This function is vectorized over all argument except 'plot': so if you
want to save multiple versions, simply provide vectors. Vectors of length
1 will be recycled using \code{\link[=rep]{rep()}}; otherwise vectors have to all be the same
length as \code{file}.
}
\examples{
plot <- ufs::ggBoxplot(mtcars, 'mpg');
ggSave(file=tempfile(fileext=".png"), plot=plot);
}
