% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{long2wide}
\alias{long2wide}
\title{Reshape Long API Data to Column-Based Format}
\usage{
long2wide(
  data,
  id_cols = intersect(.Tvars, names(data)),
  names_from = "Series",
  values_from = "Value",
  labels_from = if (any(names(data) == "Label")) "Label" else NULL,
  expand.date = FALSE,
  ...
)
}
\arguments{
\item{data}{raw data from the API: A long format data frame where all values are stacked in a value column.}

\item{id_cols}{character. Temporal identifiers of the data. By default all variables in \code{\link{.Tvars}} are selected.}

\item{names_from}{character. The column containing the series codes. These will become the names of the new columns in the wider data format.}

\item{values_from}{character. The column containing the data values.}

\item{labels_from}{character. The column containing the labels describing the series.}

\item{expand.date}{logical. \code{TRUE} will call \code{\link{expand_date}} on the data after reshaping.}

\item{\dots}{further arguments passed to \code{\link[data.table]{dcast}} or \code{\link{expand_date}}, no conflicts between these two.}
}
\value{
A \code{\link[data.table]{data.table}} with the reshaped data.
}
\description{
This function automatically reshapes long (stacked) raw data from the API (\code{\link[=get_data]{get_data(..., wide = FALSE)}}) to a wide format where each variable has its own column.
}
\examples{
\donttest{
# Return monthly macroeconomic indicators from the year 2000 onwards
long2wide(get_data("BOU_MMI", from = 2000, wide = FALSE))
}
}
\seealso{
\code{\link{wide2long}}, \code{\link{wide2excel}}, \code{\link{ugatsdb}}
}
