% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{ukb_context}
\alias{ukb_context}
\title{Demographics of a UKB sample subset}
\usage{
ukb_context(data, nonmiss.var = NULL, subset.var = NULL,
  bar.position = "fill", sex.var = "^sex.*0_0",
  age.var = "^age_when_attended_assessment_centre.*0_0",
  socioeconomic.var = "^townsend_deprivation_index_at_recruitment.*0_0",
  ethnicity.var = "^ethnic_background.*0_0",
  employment.var = "^current_employment_status_corrected.*0_0",
  centre.var = "^uk_biobank_assessment_centre.*0_0")
}
\arguments{
\item{data}{A UKB dataset constructed with \code{\link{ukb_df}}.}

\item{nonmiss.var}{The variable of interest which defines the "subset" (samples with data) and "reference" (samples without data, i.e., NA) samples.}

\item{subset.var}{A logical vector defining a "subset" (\code{TRUE}) and "reference" subset (\code{FALSE}). Length must equal the number of rows in your \code{data}.}

\item{bar.position}{This argument is passed to the \code{position} in \code{geom_bar}. The default value is \code{"fill"} which shows reference and subset of interest as proportions of the full dataset. Useful alternatives are \code{"stack"} for counts and \code{"dodge"} for side-by-side bars.}

\item{sex.var}{The variable to be used for sex. Default value is the regular expression "^sex.*0_0".}

\item{age.var}{The variable to be use for age. Default value is the regular expression "^age_when_attended_assessment_centre.*0_0".}

\item{socioeconomic.var}{The variable to be used for socioeconomic status. Default value is deprivation at baseline, the regular expression "^townsend_deprivation_index_at_recruitment.*0_0".}

\item{ethnicity.var}{The variable to be used for ethnicity. Default value is the regular expression "^ethnic_background.*0_0".}

\item{employment.var}{The variable to be used for employment status. Default value is employment status at baseline "^current_employment_status.*0_0".}

\item{centre.var}{The variable to be used for assessment centre. Default value is the regular expression "^uk_biobank_assessment_centre.*0_0".}
}
\description{
Describes a subset of the UKB sample, relative to a reference subsample, on the \href{http://biobank.ctsu.ox.ac.uk/crystal/label.cgi?id=1001}{UKB primary demographics} (sex, age, ethnicity, Townsend deprivation) and assessment centre and current employment status. The "subset" and "reference" samples are defined either by a variable of interest (\code{nonmiss.var} - those with data form the "subset" of interest and samples with missing data are the "reference" sample), or a logical vector (\code{subset.var} - where \code{TRUE} values define the "subset" and \code{FALSE} the "reference" samples) . This function is intended as an exploratory data analysis and quality control tool.
}
\examples{
\dontrun{
# Compare those with data to those without
ukb_context(my_ukb_data, nonmiss.var = "my_variable_of_interest")

# Define a subset of interest as a logical vector
subgroup_of_interest <- (my_ukb_data$bmi > 40 & my_ukb_data$age < 50)
ukb_context(my_ukb_data, subset.var = subgroup_of_interest)
}

}
\seealso{
\code{\link{ukb_df}}
}
