% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetics_qc.R
\name{ukb_gen_related_with_data}
\alias{ukb_gen_related_with_data}
\title{Subset of the UKB relatedness dataframe with data}
\usage{
ukb_gen_related_with_data(data, ukb_with_data, cutoff = 0.0884)
}
\arguments{
\item{data}{The UKB relatedness data as a dataframe (header: ID1, ID2, HetHet, IBS0, Kinship)}

\item{ukb_with_data}{A character vector of ukb eids with data on the phenotype of interest}

\item{cutoff}{KING kingship coefficient cutoff (default 0.0884 includes pairs with greater than 3rd-degree relatedness)}
}
\value{
A dataframe (header: ID1, ID2, HetHet, IBS0, Kinship) for the subset of individuals with data.
}
\description{
Subset of the UKB relatedness dataframe with data
}
\seealso{
\code{\link{ukb_gen_rel_count}}, \code{\link{ukb_gen_samples_to_remove}}
}
