% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataItemExplorer.R
\name{dataItemExplorer}
\alias{dataItemExplorer}
\title{Data Item Explorer API}
\usage{
dataItemExplorer(dataitems, fromdate, todate, datetype = "gasday",
  latestflag = "Y", applicableforflag = "Y",
  apiurl = paste0("https://marketinformation.natgrid.co.uk/",
  "MIPIws-public/public/publicwebservice.asmx"))
}
\arguments{
\item{dataitems}{A vector of characters containing data items to enquire via API.}

\item{fromdate}{A character object specifying the start date. Date is inclusive.}

\item{todate}{A character object specifying the end date. Date is inclusive.}

\item{datetype}{A character object specifying the data type. Defaults to \code{gasday}}

\item{latestflag}{A character object with length of one to specify whether to extract the latest data. This can either be \code{Y} or \code{N}. Defaults to \code{Y}.}

\item{applicableforflag}{A character object with length of one to specify whether dates specified are 'applicable for' or 'applicable on'. This can either be \code{Y} or \code{N} where \code{Y} indicates 'applicable for'. Defaults to \code{Y}.}

\item{apiurl}{A character object which points to National Grid's SOAP API. Under most circumstances users do not have to change this. Defaults to 'http://marketinformation.natgrid.co.uk/MIPIws-public/public/publicwebservice.asmx'}
}
\value{
A dataframe object containing API response data.
}
\description{
This function connects to the UK National Grid's API for Data Item Explorer, which is a major data source for gas-related information. Internet connection must be available.
}
\details{
The function submits an enquiry to the destination API using XML over HTTP using SOAP standard. The HTTP response is in XML format which function will parse internally and return a R dataframe object.
}
\examples{
# Specify the data item(s) to enquire from API
dataitems <- c("Storage Injection, Actual",
               "Storage Withdrawal, Actual")

# Initialise API (requires internet connection for this step)
response <- dataItemExplorer(dataitems,
                             fromdate = "2013-10-01",
                             todate="2015-09-30")

# Visualise the results on a chart
library(ggplot2)
ggplot(response,aes(x=ApplicableFor,y=Value,colour=PublicationObjectName)) + geom_line()
}
\references{
\itemize{
\item Graphical User Interface for Data Item Explorer\cr
\url{https://mip-prod-web.azurewebsites.net/DataItemExplorer}
\item API specification\cr
\url{https://marketinformation.natgrid.co.uk/MIPIws-public/public/publicwebservice.asmx?op=GetPublicationDataWM}
}
}
\author{
Timothy Wong, \email{timothy.wong@hotmail.co.uk}
}
