% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood-all-specific.R,
%   R/neighbourhood-events.R, R/neighbourhood-priorities.R,
%   R/neighbourhood-team.R
\name{ukc_neighbourhood_specific}
\alias{ukc_neighbourhood_specific}
\alias{ukc_neighbourhood_events}
\alias{ukc_neighbourhood_priorities}
\alias{ukc_neighbourhood_team}
\title{Specific Neighbourhood}
\usage{
ukc_neighbourhood_specific(force, neighbourhood_id)

ukc_neighbourhood_events(force, neighbourhood_id)

ukc_neighbourhood_priorities(force, neighbourhood_id)

ukc_neighbourhood_team(force, neighbourhood_id)
}
\arguments{
\item{force}{A string containing the name of the police force to return
neighbourhoods for. Must be specified, and is not case sensitive.}

\item{neighbourhood_id}{A string containing the ID of a given neighbourhood,
returned from \code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}. If missing, returns all neighbourhoods
for the specified police force, using \code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}.}
}
\value{
A list with data for a specific neighbourhood, or a tibble with all
neighbourhood IDs if no neighbourhood is specified.
}
\description{
Data on a specific neighbourhood within a given police force area.
}
\details{
\code{ukpolice} contains the following functions for specific neighbourhoods:
\itemize{
\item \code{ukc_neighbourhood_specific} -- Basic information and description of a
specific neighbourhood.
\item \code{ukc_neighbourhood_team} -- Brief biographies of police officers
responsible for the specified neighbourhood.
\item \code{ukc_neighbourhood_events} -- Police public engagement events taking
place in the specified neighbourhood.
\item \code{ukc_neighbourhood_priorities} -- Policing priorities for the
specified neighbourhood.
}
}
\examples{
\dontrun{
# returns a specific neighbourood
places4 <- ukc_neighbourhood_specific("dorset", "55.CR3001")

# returns all neighbourhoods as specific neighbourhood is unspecified.
places3 <- ukc_neighbourhood_specific("dorset")
}

\dontrun{
events <- ukc_neighbourhood_events("dorset", "55.CR3001")
}

\dontrun{
priorities <- ukc_neighbourhood_team("dorset", "55.CR3001")
}

\dontrun{
people <- ukc_neighbourhood_team("dorset", "55.CR3001")
}

}
\seealso{
\code{\link[=ukc_neighbourhood_boundary]{ukc_neighbourhood_boundary()}}

\code{\link[=ukc_neighbourhoods]{ukc_neighbourhoods()}}

\code{\link[=ukc_neighbourhood_location]{ukc_neighbourhood_location()}}
}
